/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face.model;

import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.client.model.baked.face.model.ModelLightMapReader;
import mod.chiselsandbits.client.model.baked.face.model.ModelUVReader;
import net.minecraft.class_1058;

public class ModelQuadLayer {
    private float[] uvs;
    private class_1058 sprite;
    private int light;
    private int color;
    private int tint;

    public float[] getUvs() {
        return this.uvs;
    }

    public void setUvs(float[] uvs) {
        this.uvs = uvs;
    }

    public class_1058 getSprite() {
        return this.sprite;
    }

    public void setSprite(class_1058 sprite) {
        this.sprite = sprite;
    }

    public int getLight() {
        return this.light;
    }

    public void setLight(int light) {
        this.light = light;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getTint() {
        return this.tint;
    }

    public void setTint(int tint) {
        this.tint = tint;
    }

    public static class ModelQuadLayerBuilder {
        private final ModelQuadLayer cache = new ModelQuadLayer();
        private final ModelLightMapReader lightValueExtractor;
        private ModelUVReader uvExtractor;

        public ModelQuadLayerBuilder(class_1058 sprite, int uCoord, int vCoord) {
            this.getCache().sprite = sprite;
            this.lightValueExtractor = new ModelLightMapReader();
            this.setUvExtractor(new ModelUVReader(sprite, uCoord, vCoord));
        }

        public ModelQuadLayer build(BlockInformation state, int color, int lightValue) {
            this.getCache().light = Math.max(lightValue, this.getLightValueExtractor().getLv());
            this.getCache().uvs = this.getUvExtractor().getQuadUVs();
            int n = this.getCache().color = this.getCache().tint != -1 ? color : -1;
            if (0 <= this.getCache().tint && this.getCache().tint <= 255) {
                this.getCache().color = -1;
                this.getCache().tint = IBlockStateIdManager.getInstance().getIdFrom(state.getBlockState()) << 8 | this.getCache().tint;
            } else {
                this.getCache().tint = -1;
            }
            return this.getCache();
        }

        public ModelQuadLayer getCache() {
            return this.cache;
        }

        public ModelLightMapReader getLightValueExtractor() {
            return this.lightValueExtractor;
        }

        public ModelUVReader getUvExtractor() {
            return this.uvExtractor;
        }

        public void setUvExtractor(ModelUVReader uvExtractor) {
            this.uvExtractor = uvExtractor;
        }
    }
}

